/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.model.Sheet;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class TextHeightCommand
extends AbstractCommand
implements Command {
    public static final String Command = "onZSSTextHeight";

    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)TextHeightCommand.class.getCanonicalName());
        }
        Map data = request.getData();
        if (data == null || data.size() != 4) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), TextHeightCommand.class.getCanonicalName()});
        }
        String sheetId = (String)data.get("sheetId");
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        if (!TextHeightCommand.getSheetUuid((Sheet)sheet).equals(sheetId)) {
            return;
        }
        int row = 0;
        Object obj = data.get("row");
        if (obj instanceof Number) {
            row = ((Number)obj).intValue();
        }
        int col = 0;
        obj = data.get("col");
        if (obj instanceof Number) {
            col = ((Number)obj).intValue();
        }
        int height = 0;
        obj = data.get("height");
        if (obj instanceof Number) {
            height = ((Number)obj).intValue();
        }
        ((AbstractCellAdv)sheet.getInternalSheet().getCell(row, col)).setTextHeight(height);
    }
}

